<?php

/**
 * @file
 * Contains \Drupal\video\Plugin\Field\FieldFormatter\VideoPlayerFormatterResponsive.
 */

namespace Drupal\video\Plugin\Field\FieldFormatter;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Url;

/**
 * Plugin implementation of the 'video_player_responsive' formatter.
 *
 * @FieldFormatter(
 *   id = "video_player_responsive",
 *   label = @Translation("HTML5 Video Player - Responsive"),
 *   field_types = {
 *     "video"
 *   }
 * )
 */

class VideoPlayerFormatterResponsive extends VideoPlayerFormatter {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {
    return [
      'controls' => TRUE,
      'autoplay' => FALSE,
      'loop' => FALSE,
      'muted' => FALSE,
      'preload' => 'none'
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {

    $element['controls'] = [
      '#title' => t('Show controls'),
      '#type' => 'checkbox',
      '#default_value' => $this->getSetting('controls'),
    ];
    $element['autoplay'] = [
      '#title' => t('Autoplay'),
      '#type' => 'checkbox',
      '#default_value' => $this->getSetting('autoplay'),
    ];
    $element['loop'] = [
      '#title' => t('Loop'),
      '#type' => 'checkbox',
      '#default_value' => $this->getSetting('loop'),
    ];
    $element['muted'] = [
      '#title' => t('Muted'),
      '#type' => 'checkbox',
      '#default_value' => $this->getSetting('muted'),
    ];
    $element['preload'] = [
      '#title' => t('Preload'),
      '#type' => 'select',
      '#default_value' => $this->getSetting('preload'),
      '#options' => [
        'none' =>'none',
        'metadata' => 'metadata',
        'auto' => 'auto'
      ],
      '#description' => t('Hint to the browser about whether optimistic downloading of the video itself or its metadata is considered worthwhile.')
    ];
    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];
    $summary[] = t('Settings: @controls @autoplay @loop @muted', [
      '@controls' => $this->getSetting('controls') ? t('controls') : '' ,
      '@autoplay' => $this->getSetting('autoplay') ? t('autoplaying') : '' ,
      '@loop' => $this->getSetting('loop') ? t('looping') : '' ,
      '@muted' => $this->getSetting('muted') ? t('muted') : '',
    ]);
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    $files = $this->getEntitiesToView($items, $langcode);

    // Early opt-out if the field is empty.
    if (empty($files)) {
      return $elements;
    }

    // Collect cache tags to be added for each item in the field.
    foreach ($files as $delta => $file) {
      $video_uri = $file->getFileUri();
      $elements[$delta] = [
        '#theme' => 'video_player_formatter_responsive',
        '#items' => [Url::fromUri(file_create_url($video_uri))],
        '#player_attributes' => $this->getSettings(),
      ];
    }
    return $elements;
  }
}
