/**
 * @file
 * JavaScript behaviors for jquery.inputmask integration.
 */

(function ($, Drupal) {

  'use strict';

  // Revert: Set currency prefix to empty by default #2066.
  // @see https://github.com/RobinHerbots/Inputmask/issues/2066
  if (window.Inputmask) {
    window.Inputmask.extendAliases({
      currency: {
        prefix: '$ ',
        groupSeparator: ',',
        alias: 'numeric',
        placeholder: '0',
        autoGroup: true,
        digits: 2,
        digitsOptional: false,
        clearMaskOnLostFocus: false
      },
      currency_negative: {
        prefix: '$ ',
        groupSeparator: ',',
        alias: 'numeric',
        placeholder: '0',
        autoGroup: true,
        digits: 2,
        digitsOptional: false,
        clearMaskOnLostFocus: false
      },
      currency_positive_negative: {
        prefix: '$ ',
        groupSeparator: ',',
        alias: 'numeric',
        placeholder: '0',
        autoGroup: true,
        digits: 2,
        digitsOptional: false,
        clearMaskOnLostFocus: false
      }
    });
  }

  /**
   * Initialize input masks.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.webformInputMask = {
    attach: function (context) {
      if (!$.fn.inputmask) {
        return;
      }

      $(context).find('input.js-webform-input-mask').once('webform-input-mask').inputmask();
    }
  };

})(jQuery, Drupal);
;
"use strict";!function(e,r,a){r.behaviors.dxpr_theme_breadcrumbs={attach:function(r,t){if(t.dxpr_themeSettings.breadcrumbsSeparator){var c=t.dxpr_themeSettings.breadcrumbsSeparator;e(a("dxpr_theme",".page-title-full-width-container .breadcrumb a",r)).after(' <span class="dxpr-theme-breadcrumb-spacer">'.concat(c,"</span> "))}else e(a("dxpr_theme",".page-title-full-width-container .breadcrumb a",r)).after(' <span class="dxpr-theme-breadcrumb-spacer">/</span> ')}}}(jQuery,Drupal,once);;
