<?php

/**
 * @file
 * Lists available colors and color schemes for the Bartik theme.
 */

$info = [
  // Available colors and color labels used in theme.
  'fields' => [
    'base' => t('Primary Color'),
    'link' => t('Link color'),
    'accent1' => t('Accent color 1'),
    'accent2' => t('Accent color 2'),
    'text' => t('Text color'),
    'headings' => t('Headings color'),
    'well' => t('Well color'),
    'welltext' => t('Well text'),
    'footer' => t('Footer background'),
    'footertext' => t('Footer text'),
    'secheader' => t('Secondary Header bg'),
    'secheadertext' => t('Secondary Header text'),
    'header' => t('Top Header background'),
    'headertext' => t('Top Header text'),
    'headerside' => t('Side Header/Mobile Menu background'),
    'headersidetext' => t('Side Header/Mobile Menu text'),
    'pagetitle' => t('Page Title background'),
    'pagetitletext' => t('Page Title text'),
    'graylight' => t('Gray Light'),
    'graylighter' => t('Gray Lighter'),
    'silver' => t('Silver'),
    'body' => t('Body Background'),
  ],
  // Pre-defined color schemes.
  'schemes' => [
    'default' => [
      'title' => t('DXPR Theme Default'),
      'colors' => [
        'base' => '#284ed9',
        'link' => '#284ed9',
        'accent1' => '#05e993',
        'accent2' => '#284fd8',
        'text' => '#555555',
        'headings' => '#333333',
        'footer' => '#21252a',
        'footertext' => '#747a85',
        'secheader' => '#284fd9',
        'secheadertext' => '#fffffe',
        'well' => '#eeeeee',
        'welltext' => '#444444',
        'header' => '#ffffff',
        'headertext' => '#696969',
        'headerside' => '#20252a',
        'headersidetext' => '#737a85',
        'pagetitle' => '#284fdb',
        'pagetitletext' => '#fffeff',
        'graylight' => '#cccccc',
        'graylighter' => '#ededed',
        'silver' => '#f1f1f1',
        'body' => '#efefef',
      ],
    ],
    'softwarm' => [
      'title' => t('Soft & Warm'),
      'colors' => [
        'base' => '#00aeef',
        'link' => '#00aeef',
        'accent1' => '#a8e2f7',
        'accent2' => '#ffe8e0',
        'text' => '#3c4858',
        'headings' => '#303273',
        'footer' => '#f1f1f1',
        'footertext' => '#3c4858',
        'secheader' => '#4c805a',
        'secheadertext' => '#ffffff',
        'well' => '#ffe8e0',
        'welltext' => '#303273',
        'header' => '#ffffff',
        'headertext' => '#303273',
        'headerside' => '#ffffff',
        'headersidetext' => '#303273',
        'pagetitle' => '#ffffff',
        'pagetitletext' => '#303273',
        'graylight' => '#cccccc',
        'graylighter' => '#ededed',
        'silver' => '#f1f1f1',
        'body' => '#efefef',
      ],
    ],
    'powerfulenergetic' => [
      'title' => t('Powerful & Energetic'),
      'colors' => [
        'base' => '#ef005d',
        'link' => '#ef005d',
        'accent1' => '#ffbc00',
        'accent2' => '#0085ca',
        'text' => '#333333',
        'headings' => '#000000',
        'footer' => '#f2f2f2',
        'footertext' => '#333333',
        'secheader' => '#4c805a',
        'secheadertext' => '#ffffff',
        'well' => '#ffffff',
        'welltext' => '#000000',
        'header' => '#000000',
        'headertext' => '#ffffff',
        'headerside' => '#efefef',
        'headersidetext' => '#333333',
        'pagetitle' => '#ffffff',
        'pagetitletext' => '#000000',
        'graylight' => '#bbbbbb',
        'graylighter' => '#f2f2f2',
        'silver' => '#f2f2f2',
        'body' => '#efefef',
      ],
    ],
    'brighthealthy' => [
      'title' => t('Bright & Healthy'),
      'colors' => [
        'base' => '#30c7a5',
        'link' => '#30c7a5',
        'accent1' => '#d2f5e9',
        'accent2' => '#f0f7fc',
        'text' => '#3c4858',
        'headings' => '#1e4a4c',
        'footer' => '#f5f5f5',
        'footertext' => '#3c4858',
        'secheader' => '#3d7c88',
        'secheadertext' => '#ffffff',
        'well' => '#f0f7fc',
        'welltext' => '#1e4a4c',
        'header' => '#ffffff',
        'headertext' => '#1e4a4c',
        'headerside' => '#ffffff',
        'headersidetext' => '#1e4a4c',
        'pagetitle' => '#ffffff',
        'pagetitletext' => '#1e4a4c',
        'graylight' => '#cccccc',
        'graylighter' => '#ededed',
        'silver' => '#f5f5f5',
        'body' => '#FFFFFF',
      ],
    ],
    'calmapproachable' => [
      'title' => t('Calm & Approachable'),
      'colors' => [
        'base' => '#3a6e8c',
        'link' => '#3a6e8c',
        'accent1' => '#a8d6e7',
        'accent2' => '#e9f5f9',
        'text' => '#3c4858',
        'headings' => '#2b4d66',
        'footer' => '#f1f1f1',
        'footertext' => '#3c4858',
        'secheader' => '#4c805a',
        'secheadertext' => '#ffffff',
        'well' => '#e9f5f9',
        'welltext' => '#2b4d66',
        'header' => '#ffffff',
        'headertext' => '#2b4d66',
        'headerside' => '#ffffff',
        'headersidetext' => '#2b4d66',
        'pagetitle' => '#ffffff',
        'pagetitletext' => '#2b4d66',
        'graylight' => '#cccccc',
        'graylighter' => '#ededed',
        'silver' => '#f5f5f5',
        'body' => '#FFFFFF',
      ],
    ],
    'neon' => [
      'title' => t('Bright & Vibrant Neon'),
      'colors' => [
        'base' => '#ff3ea5',
        'link' => '#18dcff',
        'accent1' => '#ff3ea5',
        'accent2' => '#18dcff',
        'text' => '#ffffff',
        'headings' => '#ffffff',
        'footer' => '#0f0f0f',
        'footertext' => '#ffffff',
        'secheader' => '#ffffff',
        'secheadertext' => '#0f0f0f',
        'well' => '#404040',
        'welltext' => '#ffffff',
        'header' => '#18dcff',
        'headertext' => '#ffffff',
        'headerside' => '#181818',
        'headersidetext' => '#ffffff',
        'pagetitle' => '#ffffff',
        'pagetitletext' => '#181818',
        'graylight' => '#808080',
        'graylighter' => '#404040',
        'silver' => '#0f0f0f',
        'body' => '#0f0f0f',
      ],
    ],
    'earthy' => [
      'title' => t('Earthy & Natural'),
      'colors' => [
        'base' => '#8b5f32',
        'link' => '#8b5f32',
        'accent1' => '#b2a89d',
        'accent2' => '#00a86b',
        'text' => '#333333',
        'headings' => '#222222',
        'footer' => '#f0f0f0',
        'footertext' => '#333333',
        'secheader' => '#4c805a',
        'secheadertext' => '#ffffff',
        'well' => '#f5f5dc',
        'welltext' => '#333333',
        'header' => '#ffffff',
        'headertext' => '#333333',
        'headerside' => '#f5f5dc',
        'headersidetext' => '#333333',
        'pagetitle' => '#8b5f32',
        'pagetitletext' => '#ffffff',
        'graylight' => '#aaaaaa',
        'graylighter' => '#f2f2f2',
        'silver' => '#f0f0f0',
        'body' => '#ffffff',
      ],
    ],
    'minimalistmonochrome' => [
      'title' => t('Minimalist & Monochrome'),
      'colors' => [
        'base' => '#3a3a3a',
        'link' => '#606060',
        'accent1' => '#808080',
        'accent2' => '#c0c0c0',
        'text' => '#3c3c3c',
        'headings' => '#1a1a1a',
        'footer' => '#3a3a3a',
        'footertext' => '#ffffff',
        'secheader' => '#606060',
        'secheadertext' => '#ffffff',
        'well' => '#ffffff',
        'welltext' => '#3c3c3c',
        'header' => '#ffffff',
        'headertext' => '#3a3a3a',
        'headerside' => '#f2f2f2',
        'headersidetext' => '#3a3a3a',
        'pagetitle' => '#606060',
        'pagetitletext' => '#ffffff',
        'graylight' => '#8c8c8c',
        'graylighter' => '#ebebeb',
        'silver' => '#d7d7d7',
        'body' => '#f6f6f6',
      ],    
    ],
    'darkmode' => [
      'title' => t('Dark Mode'),
      'colors' => [
        'base' => '#4675ff',
        'link' => '#4675ff',
        'accent1' => '#4675ff',
        'accent2' => '#4675ff',
        'text' => '#b0b0b0',
        'headings' => '#d0d0d0',
        'footer' => '#181818',
        'footertext' => '#808a95',
        'secheader' => '#181818',
        'secheadertext' => '#d0d0d0',
        'well' => '#1a1a1a',
        'welltext' => '#b0b0b0',
        'header' => '#181818',
        'headertext' => '#d0d0d0',
        'headerside' => '#1a1a1a',
        'headersidetext' => '#808a95',
        'pagetitle' => '#181818',
        'pagetitletext' => '#d0d0d0',
        'graylight' => '#404040',
        'graylighter' => '#606060',
        'silver' => '#3e3e3e',
        'body' => '#0a0a0a',
      ],
    ],        
  ],

  // CSS files (excluding @import) to rewrite with new color scheme.
  'css' => [
    // DXPR THEME BASE.
    'css/base/footer-menu.css',
    'css/base/forms.css',
    'css/base/layout.css',
    'css/base/page-title.css',
    'css/base/typography.css',
    // DXPR THEME Components.
    'css/components/dxpr-theme-full-screen-search.css',
    'css/components/dxpr-theme-header.css',
    'css/components/dxpr-theme-header--top.css',
    'css/components/dxpr-theme-header--side.css',
    'css/components/dxpr-theme-header--mobile.css',
    'css/components/dxpr-theme-secondary-header.css',
    'css/components/pager-prevnext.css',
    'css/components/dxpr-theme-admin.css',
    // Overrides.
    'css/vendor-extensions/bootstrap-3.css',
    'css/vendor-extensions/bootstrap-theme.css',
    'css/vendor-extensions/jquery-ui.css',
    'css/vendor-extensions/cubeportfolio.css',
    'css/vendor-extensions/drupal-breadcrumbs.css',
    'css/vendor-extensions/drupal-comments.css',
    'css/vendor-extensions/drupal-pager.css',
    'css/vendor-extensions/drupal-webform.css',
    'css/vendor-extensions/cms-bootstrap-core.css',
    'css/vendor-extensions/cms-bootstrap-blog.css',
    'css/vendor-extensions/cms-bootstrap-events.css',
    'css/vendor-extensions/cms-bootstrap-news.css',
    'css/vendor-extensions/cms-bootstrap-portfolio.css',
    'css/vendor-extensions/sooperthemes-premium-elements.css',
    'css/vendor-extensions/dxpr-theme-builder.css',
    // HELPERS.
    'css/helpers/helper-classes.css',
  ],

  // Files to copy.
  'copy' => [
    'logo.svg',
  ],
];
